#region Copyright Syncfusion Inc. 2001 - 2024
//
//  Copyright Syncfusion Inc. 2001 - 2024. All rights reserved.
//
//  Use of this code is subject to the terms of our license.
//  A copy of the current license can be obtained at any time by e-mailing
//  licensing@syncfusion.com. Re-distribution in any form is strictly
//  prohibited. Any infringement will be prosecuted under applicable laws. 
//
#endregion

using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Syncfusion.Pdf;
using Syncfusion.Windows.Forms;
using Syncfusion.Pdf.Interactive;
using Syncfusion.Pdf.Graphics;
using System.Drawing.Text;
using Syncfusion.Licensing;

namespace EssentialPDFSamples
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : MetroForm
    {
        # region Private Members

        private Label label1;
        private PictureBox pictureBox1;
        private Button button1;
        private PdfDocument document;
        private Font f;
        private PdfFont pdfFont;
        private PdfBrush solidBrush;
        private PdfImage img;
        private RectangleF bounds;
        private SizeF pageSize;
        private PdfPage page;
        private PdfCheckBoxField chb;
        private PdfComboBoxField comboBox;
        private float x;
        # endregion

        # region Constructor and Load
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();
            this.MinimizeBox = true;
            this.FormBorderStyle = FormBorderStyle.FixedSingle;
            this.MaximizeBox = false;
            this.StartPosition = FormStartPosition.CenterScreen;
            x = 25;
            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            this.label1 = new System.Windows.Forms.Label();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.button1 = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // label1
            // 
            this.label1.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(0)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.label1.Location = new System.Drawing.Point(0, 100);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(374, 87);
            this.label1.TabIndex = 71;
            this.label1.Text = "Click the button to view an PDF document generated by Essential PDF.  Please note" +
                " that Adobe Reader or its equivalent is required to view the resultant document." +
                "";
            // 
            // pictureBox1
            // 
            this.pictureBox1.Dock = System.Windows.Forms.DockStyle.Top;
            this.pictureBox1.Image = System.Drawing.Image.FromFile(GetFullTemplatePath("pdf_header.png", true));
            this.pictureBox1.Location = new System.Drawing.Point(0, 0);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(374, 92);
            this.pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 72;
            this.pictureBox1.TabStop = false;
            // 
            // button1
            // 
            this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.button1.BackColor = System.Drawing.Color.Transparent;
            this.button1.FlatAppearance.BorderColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(192)))), ((int)(((byte)(128)))));
            this.button1.FlatAppearance.MouseDownBackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(224)))), ((int)(((byte)(192)))));
            this.button1.FlatAppearance.MouseOverBackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.button1.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.button1.Location = new System.Drawing.Point(289, 148);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(75, 24);
            this.button1.TabIndex = 74;
            this.button1.Text = "PDF";
            this.button1.UseVisualStyleBackColor = false;
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // Form1
            // 
            //this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.BackColor = System.Drawing.Color.White;
            this.ClientSize = new System.Drawing.Size(380, 194);
            this.Controls.Add(this.button1);
            this.Controls.Add(this.label1);
            this.Controls.Add(this.pictureBox1);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            this.Icon = System.Drawing.Icon.ExtractAssociatedIcon(GetFullTemplatePath("syncfusion.ico", true));
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "Form1";
            this.Text = "Job Application";
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
			SyncfusionLicenseProvider.RegisterLicense(DemoCommon.FindLicenseKey());
            Application.EnableVisualStyles();
            Application.Run(new Form1());
        }
        # endregion

        # region Events
        private void button1_Click(object sender, System.EventArgs e)
        {
            string imagePath = GetFullTemplatePath("Careers.png", true);

            // Create a new instance of PdfDocument class.
            document = new PdfDocument();

            // Set viewer preferences for the reader 
            document.ViewerPreferences.HideMenubar = true;
            document.ViewerPreferences.HideWindowUI = true;
            document.ViewerPreferences.HideToolbar = true;
            document.ViewerPreferences.FitWindow = true;

            document.ViewerPreferences.PageLayout = PdfPageLayout.SinglePage;
            document.PageSettings.Orientation = PdfPageOrientation.Portrait;
            document.PageSettings.Margins.All = 0;

            // Set coordinates to draw form fields
            bounds = new RectangleF(180, 65, 156, 15);
            img = new PdfBitmap(imagePath);

            // Set page size
            pageSize = new SizeF(500, 310);
            document.PageSettings.Width = pageSize.Width;
            document.PageSettings.Height = pageSize.Height;

            // Initialize font and brush
            f = new Font("Calibri", 12f, FontStyle.Bold);
            pdfFont = new PdfTrueTypeFont(f);
            solidBrush = new PdfSolidBrush(new PdfColor(124, 143, 166));

            CreateFirstPage();
            CreateSecondPage();
            CreateThirdPage();

            // Save the document to disk and close it.
            document.Save("Sample.pdf");
            document.Close(true);

            //Message box confirmation to view the created PDF document.
            if (MessageBox.Show("Do you want to view the PDF file?", "PDF File Created",
                MessageBoxButtons.YesNo, MessageBoxIcon.Information)
                == DialogResult.Yes)
            {
                //Launching the PDF file using the default Application.[Acrobat Reader]
#if NETCORE
                System.Diagnostics.Process process = new System.Diagnostics.Process();
                process.StartInfo = new System.Diagnostics.ProcessStartInfo("Sample.pdf")
                {
                    UseShellExecute = true
                };
                process.Start();
#else
                System.Diagnostics.Process.Start("Sample.pdf");
#endif
                this.Close();
            }
            else
            {
                // Exit
                this.Close();
            }
        }

        # endregion

        # region Helpher Methods

        /// <summary>
        /// Creates third page in the document
        /// </summary>
        private void CreateThirdPage()
        {
            // Access third page.
            page = document.Pages[2];
            page.Graphics.DrawImage(img, 0, 0, pageSize.Width, pageSize.Height);

            f = new Font("Calibri", 12f, FontStyle.Bold);
            pdfFont = new PdfTrueTypeFont(f);

            page.Graphics.DrawString("Thank You", pdfFont, new PdfSolidBrush(new PdfColor(213, 123, 19)), x, 80);

            f = new Font("Calibri", 10f, FontStyle.Regular);
            pdfFont = new PdfTrueTypeFont(f);

            page.Graphics.DrawString("Thanks for taking the time to complete this form.\nWe will be in contact with you shortly.", pdfFont, solidBrush, x, 110);

            // Send email during button click.
            PdfButtonField submitButton1 = new PdfButtonField(page, "submitButton1");
            submitButton1.Bounds = new RectangleF(x, 160, 100, 20);
            submitButton1.Font = pdfFont;
            submitButton1.Text = "Apply";
            submitButton1.BorderStyle = PdfBorderStyle.Beveled;
            submitButton1.BackColor = new PdfColor(181, 191, 203);

            // Create a javascript action.
            PdfJavaScriptAction javaAction = new PdfJavaScriptAction("address = app.response(\"Enter an e-mail address.\",\"SEND E-MAIL\",\"\");"
                + "if (address){ cmdLine = \"mailto:\" + address;" +
                "this.submitForm(cmdLine,true,false,\"Remarks\");}");

            submitButton1.Actions.MouseUp = javaAction;

            // Add button to the form.
            document.Form.Fields.Add(submitButton1);

            document.Form.SetDefaultAppearance(false);
        }

        /// <summary>
        /// Creates second page in the document.
        /// </summary>
        private void CreateSecondPage()
        {
            //Access second page.
            page = document.Pages[1];

            page.Graphics.DrawImage(img, new PointF(0, 0), new SizeF(pageSize.Width, pageSize.Height));

            page.Graphics.DrawString("Current position", new PdfStandardFont(PdfFontFamily.TimesRoman, 10, PdfFontStyle.Bold), new PdfSolidBrush(new PdfColor(213, 123, 19)), x, 40);

            bounds.X = x; bounds.Y = 65;

            // Add fields in second page.
            // Add check box for employment status.
            CreateCheckBox(page, "Cemp", "Employment Status");
            page.Graphics.DrawString("I am not currently employed", pdfFont, solidBrush, bounds.X, bounds.Y);
            bounds.X += 90;

            page.Graphics.DrawString("Job Title", pdfFont, solidBrush, x, 85);

            bounds.X = 175;
            bounds.Y = 85;
            bounds.Width = 150;
            bounds.Height = 16;

            //Create text box for Job title.
            CreateTextBox(page, "Jtitle", "Job title", f, bounds);

            page.Graphics.DrawString("Employer:", pdfFont, solidBrush, x, 103);
            bounds.Y = bounds.Y + 18;
            //Create text box for Employer.
            CreateTextBox(page, "Employer", "Employer", f, bounds);

            page.Graphics.DrawString("Reason for leaving:", pdfFont, solidBrush, x, 123);
            bounds.Y = bounds.Y + 18;
            // Create text box for Reason.
            CreateTextBox(page, "Reason", "Reason for leaving", f, bounds);

            page.Graphics.DrawString("Total Annual salary:", pdfFont, solidBrush, x, 143);
            bounds.Y = bounds.Y + 18;
            //Create text box for annual salary.
            CreateTextBox(page, "Asalary", "Annual salary", f, bounds);
            
            page.Graphics.DrawString("Duties:", pdfFont, solidBrush, x, 168);

            bounds.Y = bounds.Y + 50;
            bounds.X = x;
            bounds.Height = bounds.Height * 4;

            //Creates textbox for Duties
            CreateTextBox(page, "Duties", "Duties", f, bounds);
            page.Graphics.DrawString("Employment type:", pdfFont, solidBrush, x, 268);

            #region Create ComboBox

            //Set position to draw Combo box.
            bounds.Y = bounds.Y + 74;
            bounds.Height = 20;
            bounds.X = 175;

            //Create a combo box.
            comboBox = new PdfComboBoxField(page, "EmpType");
            comboBox.Bounds = bounds;

            comboBox.BorderColor = new PdfColor(Color.Gray);
            comboBox.Font = pdfFont;
            comboBox.ToolTip = "Employment type";

            // Add list items.
            comboBox.Items.Add(new PdfListFieldItem("Full time", "ft"));
            comboBox.Items.Add(new PdfListFieldItem("Part time", "pt"));

            // Add combo box to the form.
            document.Form.Fields.Add(comboBox);
            #endregion

            // Add navigation button for the third page.
            NavigateToNextPage(page, "Apply");
        }

        /// <summary>
        /// Adds navigation button.
        /// </summary>
        /// <param name="currentPage"></param>
        /// <param name="buttonText"></param>
        private void NavigateToNextPage(PdfPage currentPage, string buttonText)
        {
            // Create a Button field.
            PdfButtonField submitButton = new PdfButtonField(page, buttonText);
            submitButton.Bounds = new RectangleF(page.GetClientSize().Width - 30, page.GetClientSize().Height - x, 25, 15);
            submitButton.Font = pdfFont;
            submitButton.ToolTip = buttonText;

            // Add a new page.
            page = document.Pages.Add();

            // Create an instance of PdfDestination.
            PdfDestination dest = new PdfDestination(page, new Point(0, 100));

            // Create an instance of GoTo action.
            PdfGoToAction goToAction = new PdfGoToAction(page);

            // Update the destination for the action.
            goToAction.Destination = dest;

            // Set action for the field.
            submitButton.Actions.GotFocus = goToAction;
        }

        /// <summary>
        /// Creates first page in the document.
        /// </summary>
        private void CreateFirstPage()
        {
            // Add a new page.
            page = document.Pages.Add();

            page.Graphics.DrawImage(img, 0, 0, pageSize.Width, pageSize.Height);
            page.Graphics.DrawString("General Information", pdfFont, new PdfSolidBrush(new PdfColor(213, 123, 19)), x, 40);
            page.Graphics.DrawString("Education Grade", pdfFont, new PdfSolidBrush(new PdfColor(213, 123, 19)), x, 190);

            // Update font
            f = new Font("Calibri", 10f);
            pdfFont = new PdfTrueTypeFont(f);

            // Create fields for first page.
            page.Graphics.DrawString("First Name:", pdfFont, solidBrush, x, 65);

            //Create text box for FirstName.
            CreateTextBox(page, "FirstName", "First Name", f, bounds);

            page.Graphics.DrawString("Last Name:", pdfFont, solidBrush, x, 83);
            bounds.Y += 18;

            //Create text box for LastName.
            CreateTextBox(page, "LastName", "Last Name", f, bounds);

            page.Graphics.DrawString("Email:", pdfFont, solidBrush, x, 103);
            bounds.Y += 18;

            //Create text box for Email.
            CreateTextBox(page, "Email", "Email id", f, bounds);

            page.Graphics.DrawString("Business Phone:", pdfFont, solidBrush, x, 123);
            bounds.Y += 18;

            //Create text box for Business phone.
            CreateTextBox(page, "Business", "Business phone", f, bounds);

            page.Graphics.DrawString("Which position are\nyou applying for?", pdfFont, solidBrush, x, 143);

            bounds.Y += 24;

            #region Create ComboBox

            // Create a combo box for the first page.
            PdfComboBoxField comboBox = new PdfComboBoxField(page, "JobTitle");
            comboBox.Bounds = bounds;
            comboBox.BorderWidth = 1;
            comboBox.BorderColor = new PdfColor(Color.Gray);

            comboBox.Font = pdfFont;

            // Set tooltip
            comboBox.ToolTip = "Job Title";

            // Add list items.
            comboBox.Items.Add(new PdfListFieldItem("Development", "accounts"));
            comboBox.Items.Add(new PdfListFieldItem("Support", "advertise"));
            comboBox.Items.Add(new PdfListFieldItem("Documentation", "agri"));

            // Add combo box to the form.
            document.Form.Fields.Add(comboBox);
            #endregion

            page.Graphics.DrawString("Highest qualification", pdfFont, solidBrush, x, 217);

            #region Create CheckBox
            //Set position to draw Checkbox
            bounds.Y = 239;
            bounds.X = x;
            bounds.Width = 10;

            bounds.Height = 10;

            // Create check box for Associate Degree.
            CreateCheckBox(page, "Adegree", "Degree");
            page.Graphics.DrawString("Associate degree", pdfFont, solidBrush, bounds.X, bounds.Y);
            bounds.X += 90;

            // Create check box for Bachelor Degree.
            CreateCheckBox(page, "Bdegree", "Degree");
            page.Graphics.DrawString("Bachelor degree", pdfFont, solidBrush, bounds.X, bounds.Y);
            bounds.X += 90;

            // Create check box for College.
            CreateCheckBox(page, "college", "College");
            page.Graphics.DrawString("College", pdfFont, solidBrush, bounds.X, bounds.Y);

            bounds.Y += 20;
            bounds.X = x;

            // Create check box for PG.
            CreateCheckBox(page, "pg", "PG");
            page.Graphics.DrawString("Post Graduate", pdfFont, solidBrush, bounds.X, bounds.Y);
            bounds.X += 90;

            // Create check box for MBA.
            CreateCheckBox(page, "mba", "MBA");
            page.Graphics.DrawString("MBA", pdfFont, solidBrush, bounds.X, bounds.Y);

            #endregion

            // Add navigation button for the second page.
            NavigateToNextPage(page, "Next");
        }

        /// <summary>
        /// Creates check box and adds it to the form.
        /// </summary>
        /// <param name="page"></param>
        /// <param name="name"></param>
        /// <param name="tooltip"></param>
        private void CreateCheckBox(PdfPage page, string name, string tooltip)
        {
            // Create a Check box field.
            PdfCheckBoxField chb = new PdfCheckBoxField(page, name);

            // Set check box properties.
            chb.Font = pdfFont;
            chb.ToolTip = tooltip;
            chb.Bounds = bounds;
            chb.BorderColor = new PdfColor(Color.Gray);
            bounds.X += chb.Bounds.Height + 10;

            document.Form.Fields.Add(chb);
        }

        /// <summary>
        /// Creates textbox and adds it in the form.
        /// </summary>
        /// <param name="page"></param>
        /// <param name="text"></param>
        /// <param name="tooltip"></param>
        /// <param name="f"></param>
        /// <param name="bounds"></param>
        protected void CreateTextBox(PdfPage page, string text, string tooltip, Font f, RectangleF bounds)
        {
            // Create a Text box field.
            PdfTextBoxField textBoxField = new PdfTextBoxField(page, text);

            PdfTrueTypeFont font = new PdfTrueTypeFont(f);

            //Set properties to the textbox.
            textBoxField.Font = font;
            textBoxField.BorderColor = new PdfColor(Color.Gray);
            textBoxField.BorderStyle = PdfBorderStyle.Beveled;
            textBoxField.Bounds = bounds;
            textBoxField.ToolTip = tooltip;

            document.Form.Fields.Add(textBoxField);
        }

        /// <summary>
        /// Gets the full path of the PDF template or image.
        /// </summary>
        /// <param name="fileName">Name of the file</param>
        /// <param name="image">True if image</param>
        /// <returns>Path of the file</returns>
        private string GetFullTemplatePath(string fileName, bool image)
        {
#if NETCORE
            string fullPath = @"..\..\..\..\..\..\..\Common\";
#else
            string fullPath = @"..\..\..\..\..\..\Common\";
#endif
            string folder = image ? "Images" : "Data";

            return string.Format(@"{0}{1}\PDF\{2}", fullPath, folder, fileName);
        }
        #endregion
    }
	/// <summary>
    /// Represents a class that is used to find the licensing file for Syncfusion controls.
    /// </summary>
    public class DemoCommon
    {

        /// <summary>
        /// Finds the license key from the Common folder.
        /// </summary>
        /// <returns>Returns the license key.</returns>
        public static string FindLicenseKey()
        {

            string licenseKeyFile = "Common\\SyncfusionLicense.txt";

            for (int n = 0; n < 20; n++)
            {
                if (!System.IO.File.Exists(licenseKeyFile))
                {
                    licenseKeyFile = @"..\" + licenseKeyFile;
                    continue;
                }
                return System.IO.File.ReadAllText(licenseKeyFile);
            }
            return string.Empty;
        }
    }
}
